/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.swing.PHighlightedTextArea;
import edu.princeton.swing.text.HighlightedDocument;
import edu.princeton.toy.TUncommentingAutoCompleter;
import edu.princeton.toy.lang.TWord;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;

public class TCommentingAutoCompleter
extends TUncommentingAutoCompleter {
    @Override
    public boolean interceptKeyEvent(PHighlightedTextArea comp, KeyEvent e) {
        if (super.interceptKeyEvent(comp, e)) {
            return true;
        }
        if (e.isActionKey() && e.getKeyCode() != 39 && e.getKeyCode() != 37) {
            return false;
        }
        int mask = System.getProperty("os.name").startsWith("Mac") ? 256 : 128;
        if ((e.getModifiersEx() & mask) == mask && (e.getKeyChar() == 'c' || e.getKeyChar() == 'z' || e.getKeyChar() == 'o' || e.getKeyChar() == 'n' || e.getKeyChar() == 'q' || e.getKeyChar() == 's' || e.getKeyChar() == 'a' || e.getKeyChar() == 'e' || e.getKeyChar() == 'f' || e.getKeyChar() == 'y')) {
            return false;
        }
        int selectionDot = comp.getSelectionDot();
        HighlightedDocument document = comp.getDocument();
        Point coordinate = document.offsetToCoordinate(selectionDot);
        int lineStartDot = selectionDot - coordinate.x;
        int lineEndDot = document.coordinateToOffset(Integer.MAX_VALUE, coordinate.y);
        String line = document.getText(lineStartDot, lineEndDot);
        int length = line.length();
        boolean hasInstruction = false;
        if (length >= 8) {
            hasInstruction = TWord.isCommand(line.substring(0, 8));
        }
        Point selStart = document.offsetToCoordinate(comp.getSelectionStart());
        Point selEnd = document.offsetToCoordinate(comp.getSelectionEnd());
        boolean hasSelection = selStart.x != selEnd.x && selStart.y == selEnd.y || selStart.y != selEnd.y;
        boolean startIn = selStart.x >= 8 && selStart.x <= 41;
        boolean startAfter = selStart.x > 41;
        mask = 64;
        int mark = selectionDot == comp.getSelectionStart() ? comp.getSelectionEnd() : comp.getSelectionStart();
        if (hasInstruction && coordinate.x == 8 && e.getKeyCode() == 39 && e.getID() == 401) {
            int newPos = selectionDot + 41 - 8;
            if ((e.getModifiersEx() & mask) == mask) {
                comp.select(newPos, mark, newPos);
            } else {
                comp.select(newPos, newPos, newPos);
            }
            return true;
        }
        if (hasInstruction && coordinate.x == 41 && e.getKeyCode() == 37 && e.getID() == 401) {
            int newPos = selectionDot - 41 + 8;
            if ((e.getModifiersEx() & mask) == mask) {
                comp.select(newPos, mark, newPos);
            } else {
                comp.select(newPos, newPos, newPos);
            }
            return true;
        }
        if (e.getKeyCode() == 39 || e.getKeyCode() == 37) {
            return false;
        }
        if (startAfter || selStart.x == 41 && hasSelection || coordinate.x == 41 && e.getKeyCode() != 8 && selStart.x >= coordinate.x) {
            return false;
        }
        if (hasInstruction && startIn) {
            if (coordinate.x == 8 && e.getKeyCode() == 8) {
                return false;
            }
            if (this.canBeep(e)) {
                Toolkit.getDefaultToolkit().beep();
            }
            return true;
        }
        if (hasInstruction && !hasSelection && coordinate.x < 8 && e.getKeyCode() != 8 && e.getKeyChar() != '\n') {
            if (this.canBeep(e)) {
                Toolkit.getDefaultToolkit().beep();
            }
            return true;
        }
        return false;
    }

    private boolean canBeep(KeyEvent e) {
        return e.getID() == 401 && e.getKeyCode() != 16 && e.getKeyCode() != 17 && e.getKeyCode() != 157 && e.getKeyCode() != 27;
    }
}

